/*****************************************************************************
*  LPC81x Match Toggle for the LPC812 LPCXpresso board
*
*  1. Use SCT timer to generate a 100 msec clock output @ CTOUT_0
*  2. CTOUT_0 is linked to P0_7 (toggles every 100 msec)
*****************************************************************************/
#include "board.h"

#define match_value (10000)

extern void sct_fsm_init (void);

void sct_fsm_init (void)
{

	Chip_SCT_Init(LPC_SCT);														                            /* enable the SCT clock     */

	Chip_SCT_Config(LPC_SCT,  SCT_CONFIG_AUTOLIMIT_L ); /* SPLIT */


	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(239));	                          /* System core clock 24Mhz, set prescaler, SCT clock = 1 MHz   */
								 


	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, match_value);					          // match 0 @ 10Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, match_value);

	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0 );  			 		            // event 0 will set SCT_OUT_0
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0);                       // event 0 will clear SCT_OUT_0


	/* Conflict resolution register */
	Chip_SCT_SetConflictResolution(LPC_SCT, 0, SCT_RES_TOGGLE_OUTPUT);            // output 0 toggles on conflict


	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					            // event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0	|   // MATCHSEL[3:0]   = related to match 0
                                                                        SCT_COMBMODE_MATCH	|   // COMBMODE[13:12] = match condition only
                                                                        SCT_STATELD_1		    |   // STATELD [14]    = STATEV is loaded into state
                                                                        SCT_STATEEV_0		    )); // STATEV  [15]    = new state is 0


	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}


int main(void)
{
	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();

	Chip_SWM_Init();
	
	Chip_SWM_MovablePinAssign(SWM_CTOUT_0_O, 7);

	sct_fsm_init();                      	/* Initialize the SCT using the code generated by Red State */


    while(1)
    {
        __WFI();
    }
}
